/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.item.ISpecBuilder;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.blocks.tiles.TileCopy;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumQuestRepeat;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.containers.ContainerAvailabilityInv;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DropController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.ClientScriptData;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.DropsTemplate;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.ForgeScriptData;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.NpcScriptData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PotionScriptData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.controllers.data.Zone3D;
import noppes.npcs.dimensions.CustomWorldInfo;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.entity.data.Resistances;
import noppes.npcs.items.ItemBoundary;
import noppes.npcs.items.crafting.NpcShapedRecipes;
import noppes.npcs.items.crafting.NpcShapelessRecipes;
import noppes.npcs.roles.JobBard;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.roles.data.SpawnNPCData;
import noppes.npcs.schematics.Schematic;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.util.BuilderData;
import noppes.npcs.util.IPermission;
import noppes.npcs.util.Util;

public class PacketHandlerServer {
    private static List<EnumPacketServer> list = new ArrayList<EnumPacketServer>();

    private boolean allowItem(ItemStack stack, EnumPacketServer type) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        IPermission permission = null;
        if (item instanceof IPermission) {
            permission = (IPermission)item;
        } else if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IPermission) {
            permission = (IPermission)((ItemBlock)item).func_179223_d();
        }
        return permission != null && permission.isAllowed(type);
    }

    private void handlePacket(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws Exception {
        if (type == EnumPacketServer.Delete) {
            if (npc.advanced.jobInterface instanceof JobBard) {
                JobBard job = (JobBard)npc.advanced.jobInterface;
                Server.sendData(player, EnumPacketClient.STOP_SOUND, job.song, (job.isStreamer ? SoundCategory.AMBIENT : SoundCategory.MUSIC).ordinal());
            }
            npc.delete();
            NoppesUtilServer.deleteEntity((EntityLivingBase)npc);
        } else if (type == EnumPacketServer.SceneStart) {
            if (CustomNpcs.SceneButtonsEnabled) {
                DataScenes.Toggle(buffer.readInt() + "btn");
            }
        } else if (type == EnumPacketServer.SceneReset) {
            if (CustomNpcs.SceneButtonsEnabled) {
                DataScenes.Reset((ICommandSender)player, null);
            }
        } else if (type == EnumPacketServer.LinkedAdd) {
            LinkedNpcController.Instance.addData(Server.readString(buffer));
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
        } else if (type == EnumPacketServer.LinkedRemove) {
            LinkedNpcController.Instance.removeData(Server.readString(buffer));
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
        } else if (type == EnumPacketServer.LinkedGetAll) {
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
            if (npc != null) {
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, npc.linkedName);
            }
        } else if (type == EnumPacketServer.LinkedSet) {
            npc.linkedName = Server.readString(buffer);
            LinkedNpcController.Instance.loadNpcData(npc);
        } else if (type == EnumPacketServer.NpcMenuClose) {
            npc.reset();
            if (npc.linkedData != null) {
                LinkedNpcController.Instance.saveNpcData(npc);
            }
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, null);
        } else if (type == EnumPacketServer.BanksGet) {
            NoppesUtilServer.sendBankDataAll(player);
        } else if (type == EnumPacketServer.BankGet) {
            Bank bank = BankController.getInstance().getBank(buffer.readInt());
            NoppesUtilServer.sendBank(player, bank, buffer.readInt());
        } else if (type == EnumPacketServer.BankSave) {
            Bank bank = new Bank();
            bank.readFromNBT(Server.readNBT(buffer));
            BankController.getInstance().saveBank(bank);
            BankController.getInstance().change(bank);
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, bank, 0);
        } else if (type == EnumPacketServer.BankAddCeil) {
            Bank bank = BankController.getInstance().getBank(buffer.readInt());
            if (bank == null) {
                return;
            }
            Bank.CeilSettings cs = bank.addCeil();
            NoppesUtilServer.sendBank(player, bank, cs.ceil);
        } else if (type == EnumPacketServer.BankRemove) {
            int bankId = buffer.readInt();
            int ceilId = buffer.readInt();
            if (ceilId < 0) {
                Server.sendData(player, EnumPacketClient.SYNC_REMOVE, new Object[]{EnumSync.BankData, bankId});
                BankController.getInstance().removeBank(bankId);
                NoppesUtilServer.sendBankDataAll(player);
            } else {
                Bank bank = BankController.getInstance().getBank(bankId);
                if (bank == null) {
                    return;
                }
                bank.removeCeil(ceilId);
                if (--ceilId < 0) {
                    ceilId = 0;
                }
                Server.sendData(player, EnumPacketClient.SYNC_REMOVE, new Object[]{EnumSync.BankCeil, ceilId, bankId});
                NoppesUtilServer.sendBank(player, bank, ceilId);
            }
        } else if (type == EnumPacketServer.RemoteMainMenu) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (!(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)entity);
        } else if (type == EnumPacketServer.RemoteDelete) {
            int id = buffer.readInt();
            Entity entity = player.field_70170_p.func_73045_a(id);
            if (entity == null) {
                return;
            }
            if (entity instanceof EntityNPCInterface) {
                npc = (EntityNPCInterface)entity;
                npc.delete();
            } else {
                entity.func_70106_y();
            }
            NoppesUtilServer.deleteEntity((EntityLivingBase)entity);
            NoppesUtilServer.sendNearbyEntitys(player, buffer.readBoolean());
        } else if (type == EnumPacketServer.RemoteNpcsGet) {
            NoppesUtilServer.sendNearbyEntitys(player, buffer.readBoolean());
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteFreeze) {
            CustomNpcs.FreezeNPCs = !CustomNpcs.FreezeNPCs;
            player.func_145747_a((ITextComponent)new TextComponentString(CustomNpcs.FreezeNPCs ? "Freeze Npcs" : "Unfreeze Npcs"));
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Freeze Npcs" : "Unfreeze Npcs");
        } else if (type == EnumPacketServer.RemoteReset) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (!(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.reset();
        } else if (type == EnumPacketServer.RemoteTpToNpc) {
            if (buffer.readBoolean()) {
                Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
                if (entity == null) {
                    return;
                }
                player.field_71135_a.func_147364_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
            } else {
                BlockPos pos = BlockPos.func_177969_a((long)buffer.readLong());
                player.field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            }
        } else if (type == EnumPacketServer.Gui) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, gui, npc, x, y, z);
        } else if (type == EnumPacketServer.RecipeRemove) {
            RecipeController.getInstance().delete(buffer.readBoolean(), Server.readString(buffer), Server.readString(buffer));
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.RecipeSave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            if (compound.func_74779_i("Domen").equals("customnpcs")) {
                IRecipe recipe = compound.func_74767_n("IsShaped") ? NpcShapedRecipes.read(compound) : NpcShapelessRecipes.read(compound);
                RecipeController.getInstance().register((INpcRecipe)recipe);
                RecipeController.getInstance().updateGroupToAll(recipe.isGlobal(), recipe.getNpcGroup());
            }
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.NaturalSpawnGetAll) {
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnGet) {
            SpawnData spawn = SpawnController.instance.getSpawnData(buffer.readInt());
            if (spawn != null) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, spawn.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPacketServer.NaturalSpawnSave) {
            SpawnData data = new SpawnData();
            data.readNBT(Server.readNBT(buffer));
            SpawnController.instance.saveSpawnData(data);
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnRemove) {
            SpawnController.instance.removeSpawnData(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategorySave) {
            DialogCategory category = new DialogCategory();
            category.load(Server.readNBT(buffer));
            DialogController.instance.saveCategory(category);
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.DialogCategoryRemove) {
            DialogController.instance.removeCategory(buffer.readInt());
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.DialogGuiSettings) {
            NBTTagCompound compound = Server.readNBT(buffer);
            DialogController.instance.getGuiSettings().load(compound);
            DialogController.instance.saveSettings();
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_END, new Object[]{EnumSync.DialogGuiSettings, compound});
        } else if (type == EnumPacketServer.DialogSave) {
            DialogCategory category = DialogController.instance.categories.get(buffer.readInt());
            if (category == null) {
                return;
            }
            Dialog dialog = new Dialog(category);
            dialog.load(Server.readNBT(buffer));
            DialogController.instance.saveDialog(category, dialog);
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.DialogRemove) {
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            if (dialog != null && dialog.category != null) {
                DialogController.instance.removeDialog(dialog);
                Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
            }
        } else if (type == EnumPacketServer.QuestOpenGui) {
            Quest quest = new Quest(null);
            int gui = buffer.readInt();
            quest.load(Server.readNBT(buffer));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, quest);
            player.openGui((Object)CustomNpcs.instance, gui, player.field_70170_p, 0, 0, 0);
        } else if (type == EnumPacketServer.DialogNpcGet) {
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPacketServer.DialogNpcSet) {
            int slot = buffer.readInt();
            int dialogID = buffer.readInt();
            Server.sendData(player, EnumPacketClient.GUI_DATA, NoppesUtilServer.setNpcDialog(slot, dialogID, (EntityPlayer)player));
        } else if (type == EnumPacketServer.DialogNpcRemove) {
            int slot = buffer.readInt();
            if (slot < 0 || slot >= npc.dialogs.length) {
                return;
            }
            int[] newIDs = new int[npc.dialogs.length - 1];
            int j = 0;
            for (int i = 0; i < npc.dialogs.length; ++i) {
                if (i == slot) continue;
                newIDs[j] = npc.dialogs[i];
                ++j;
            }
            npc.dialogs = newIDs;
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPacketServer.DialogNpcMove) {
            NoppesUtilServer.moveNpcDialogs((EntityPlayer)player, buffer.readInt(), buffer.readBoolean());
        } else if (type == EnumPacketServer.SpawnerNpcMove) {
            NoppesUtilServer.moveNpcSpawn(player, buffer.readInt(), buffer.readBoolean(), buffer.readBoolean());
        } else if (type == EnumPacketServer.QuestCategorySave) {
            QuestCategory category = new QuestCategory();
            category.load(Server.readNBT(buffer));
            QuestController.instance.saveCategory(category);
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.QuestCategoryRemove) {
            QuestController.instance.removeCategory(buffer.readInt());
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.QuestSave) {
            QuestCategory category = QuestController.instance.categories.get(buffer.readInt());
            if (category == null) {
                return;
            }
            Quest quest = new Quest(category);
            quest.load(Server.readNBT(buffer));
            if (quest.completer == null) {
                if (npc != null) {
                    NBTTagCompound compound = new NBTTagCompound();
                    npc.func_70014_b(compound);
                    Entity e = EntityList.func_75615_a((NBTTagCompound)compound, (World)npc.field_70170_p);
                    if (e instanceof EntityNPCInterface) {
                        quest.completer = (EntityNPCInterface)e;
                    }
                }
            } else if (npc != null && quest.completer.func_70005_c_().equals(npc.func_70005_c_())) {
                NBTTagCompound compound = new NBTTagCompound();
                npc.func_70014_b(compound);
                quest.completer.func_70037_a(compound);
            } else if (CustomNpcs.Server != null) {
                for (WorldServer w : CustomNpcs.Server.field_71305_c) {
                    boolean found = false;
                    for (Entity e : w.field_72996_f) {
                        if (!(e instanceof EntityNPCInterface) || !e.func_70005_c_().equals(quest.completer.func_70005_c_())) continue;
                        NBTTagCompound nbtNPC = new NBTTagCompound();
                        ((EntityNPCInterface)e).func_70014_b(nbtNPC);
                        quest.completer.func_70037_a(nbtNPC);
                        found = true;
                        break;
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            } else {
                assert (npc != null);
                quest.completer.display.setName(npc.func_70005_c_());
            }
            QuestController.instance.saveQuest(category, quest);
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.QuestCategoriesData, category.save(new NBTTagCompound())});
        } else if (type == EnumPacketServer.QuestReset) {
            Quest quest = new Quest(null);
            quest.load(Server.readNBT(buffer));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, quest);
            int taskPos = buffer.readInt();
            if (taskPos >= 0) {
                NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.QuestTypeItem, npc, taskPos, 0, 0);
            }
        } else if (type == EnumPacketServer.DialogMinID) {
            int i;
            int id;
            int idNow = buffer.readInt();
            ArrayList<Integer> ids = new ArrayList<Integer>(DialogController.instance.dialogs.keySet());
            Collections.sort(ids);
            Iterator e = ids.iterator();
            for (id = 1; e.hasNext() && id == (i = ((Integer)e.next()).intValue()) && id != idNow; ++id) {
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("MinimumID", id);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.FactionMinID) {
            int i;
            int id;
            int idNow = buffer.readInt();
            ArrayList<Integer> ids = new ArrayList<Integer>(FactionController.instance.factions.keySet());
            Collections.sort(ids);
            NBTTagCompound compound = ids.iterator();
            for (id = 0; compound.hasNext() && id == (i = ((Integer)compound.next()).intValue()) && id != idNow; ++id) {
            }
            compound = new NBTTagCompound();
            compound.func_74768_a("MinimumID", id);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.QuestMinID) {
            int i;
            int id;
            int idNow = buffer.readInt();
            ArrayList<Integer> ids = new ArrayList<Integer>(QuestController.instance.quests.keySet());
            Collections.sort(ids);
            NBTTagCompound compound = ids.iterator();
            for (id = 1; compound.hasNext() && id == (i = ((Integer)compound.next()).intValue()) && id != idNow; ++id) {
            }
            compound = new NBTTagCompound();
            compound.func_74768_a("MinimumID", id);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.QuestDialogGetTitle) {
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            if (dialog == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Title", dialog.title);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.QuestRemove) {
            int id = buffer.readInt();
            if (QuestController.instance.quests.containsKey(id)) {
                QuestController.instance.removeQuest(QuestController.instance.quests.get(id));
            }
            for (QuestCategory cat : QuestController.instance.categories.values()) {
                cat.quests.remove(id);
            }
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.TransportCategoriesGet) {
            try {
                int id = buffer.readInt();
                NoppesUtilServer.sendTransportData(player, id);
            }
            catch (Exception e) {
                NoppesUtilServer.sendTransportData(player);
            }
        } else if (type == EnumPacketServer.TransportCategorySave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            int id = compound.func_74762_e("CategoryId");
            TransportController.getInstance().saveCategory(compound);
            if (id < 0) {
                NoppesUtilServer.sendTransportData(player);
            }
        } else if (type == EnumPacketServer.TransportCategoryRemove) {
            TransportController.getInstance().removeCategory(buffer.readInt());
            NoppesUtilServer.sendTransportData(player);
        } else if (type == EnumPacketServer.TransportRemove) {
            int id = buffer.readInt();
            TransportLocation loc = TransportController.getInstance().removeLocation(id);
            if (loc != null) {
                NoppesUtilServer.sendTransportData(player);
            }
        } else if (type == EnumPacketServer.TransportSave) {
            int cat = buffer.readInt();
            TransportLocation location = TransportController.getInstance().saveLocation(cat, Server.readNBT(buffer), npc);
            if (location != null) {
                if (!(npc.advanced.roleInterface instanceof RoleTransporter)) {
                    return;
                }
                RoleTransporter role = (RoleTransporter)npc.advanced.roleInterface;
                role.setTransport(location);
            }
        } else if (type == EnumPacketServer.TransportGetLocation) {
            if (!(npc.advanced.roleInterface instanceof RoleTransporter)) {
                return;
            }
            RoleTransporter role = (RoleTransporter)npc.advanced.roleInterface;
            if (role.hasTransport()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, role.getLocation().writeNBT());
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, role.getLocation().category.title);
            }
        } else if (type == EnumPacketServer.FactionSet) {
            npc.setFaction(buffer.readInt());
        } else if (type == EnumPacketServer.FactionSave) {
            Faction faction = new Faction();
            faction.load(Server.readNBT(buffer));
            FactionController.instance.saveFaction(faction);
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            faction.save(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.FactionRemove) {
            FactionController.instance.delete(buffer.readInt());
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            new Faction().save(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.PlayerDataGet) {
            int id = buffer.readInt();
            if (EnumPlayerData.values().length <= id) {
                return;
            }
            String name = null;
            EnumPlayerData datatype = EnumPlayerData.values()[id];
            if (datatype != EnumPlayerData.Players) {
                name = Server.readString(buffer);
            }
            NoppesUtilServer.sendPlayerData(datatype, player, name);
        } else if (type == EnumPacketServer.PlayerDataRemove) {
            int id = buffer.readInt();
            if (EnumPlayerData.values().length <= id) {
                return;
            }
            if (EnumPlayerData.values()[id] == EnumPlayerData.Wipe) {
                List<String> list = PlayerDataController.instance.getPlayerNames();
                Collections.addAll(list, Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_72369_d());
                for (String name : list) {
                    EntityPlayerMP pl = player.func_184102_h().func_184103_al().func_152612_a(name);
                    PlayerData playerdata = pl == null ? PlayerDataController.instance.getDataFromUsername(player.func_184102_h(), name) : PlayerData.get((EntityPlayer)pl);
                    playerdata.setNBT(new NBTTagCompound());
                    playerdata.save(true);
                    if (pl == null) continue;
                    SyncController.syncPlayer(pl);
                }
                Util.instance.removeFile(Objects.requireNonNull(CustomNpcs.getWorldSaveDirectory("playerdata")));
                if (Objects.requireNonNull(CustomNpcs.getWorldSaveDirectory("playerdata")).mkdirs()) {
                    NoppesUtilServer.sendPlayerData(EnumPlayerData.Players, player, null);
                }
                return;
            }
            NoppesUtilServer.removePlayerData(id, buffer, player);
        } else if (type == EnumPacketServer.MainmenuDisplayGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.display.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuDisplaySave) {
            npc.display.readToNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuStatsGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.stats.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuStatsSave) {
            npc.stats.readToNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuInvGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
            DropController.getInstance().sendTo(player);
        } else if (type == EnumPacketServer.MainmenuInvSave) {
            npc.inventory.readEntityFromNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.updateClient = true;
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuInvDropSave) {
            int dropType = buffer.readInt();
            int groupId = buffer.readInt();
            int slot = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            IItemStack stack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(compound.func_74775_l("Item")));
            DropsTemplate template = DropController.getInstance().templates.get(npc.inventory.saveDropsName);
            if (stack.isEmpty()) {
                if (dropType == 1) {
                    if (template != null) {
                        if (slot < 0) {
                            template.removeGroup(groupId);
                        } else {
                            template.removeDrop(groupId, slot);
                        }
                    }
                } else {
                    npc.inventory.removeDrop(slot);
                }
            } else if (slot == -1) {
                DropSet drop = null;
                if (dropType == 1) {
                    if (template != null) {
                        drop = template.addDropItem(groupId, stack, 85.0);
                    }
                } else {
                    drop = (DropSet)npc.inventory.addDropItem(stack, 1.0);
                }
                if (drop != null) {
                    drop.load(compound);
                }
            } else if (dropType == 1) {
                if (template != null && template.groups.containsKey(groupId) && template.groups.get(groupId).containsKey(slot)) {
                    template.groups.get(groupId).get(slot).load(compound);
                }
            } else if (npc.inventory.drops.containsKey(slot)) {
                npc.inventory.drops.get(slot).load(compound);
            }
            npc.updateAI = true;
            npc.updateClient = true;
            DropController.getInstance().sendTo(player);
            DropController.getInstance().save();
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAIGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ais.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAISave) {
            npc.ais.readToNBT(Server.readNBT(buffer));
            npc.func_70606_j(npc.func_110138_aP());
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAdvancedGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.save(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAdvancedSave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            npc.advanced.load(compound);
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAdvancedMarkData) {
            MarkData data = MarkData.get((EntityLivingBase)npc);
            data.setNBT(Server.readNBT(buffer));
            data.syncClients();
        } else if (type == EnumPacketServer.JobSave) {
            NBTTagCompound original = npc.advanced.jobInterface.save(new NBTTagCompound());
            NBTTagCompound compound = Server.readNBT(buffer);
            for (String name : compound.func_150296_c()) {
                if (name.equals("DataEntitysWhenAlive") || name.equals("DataEntitysWhenDead")) continue;
                original.func_74782_a(name, compound.func_74781_a(name));
            }
            if (original.func_150297_b("Type", 3)) {
                npc.advanced.jobInterface.load(original);
                npc.updateClient = true;
            }
        } else if (type == EnumPacketServer.JobClear) {
            if (!(npc.advanced.jobInterface instanceof JobSpawner)) {
                return;
            }
            ((JobSpawner)npc.advanced.jobInterface).clear(buffer.readBoolean());
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.advanced.jobInterface.save(compound);
            ((JobSpawner)npc.advanced.jobInterface).cleanCompound(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.JobGet) {
            if (npc.advanced.jobInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.advanced.jobInterface.save(compound);
            if (npc.advanced.jobInterface instanceof JobSpawner) {
                ((JobSpawner)npc.advanced.jobInterface).cleanCompound(compound);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.JobSpawnerAdd) {
            if (!(npc.advanced.jobInterface instanceof JobSpawner)) {
                return;
            }
            JobSpawner job = (JobSpawner)npc.advanced.jobInterface;
            boolean isServerSide = buffer.readBoolean();
            boolean isDead = buffer.readBoolean();
            int slot = buffer.readInt();
            if (isServerSide) {
                String name = Server.readString(buffer);
                int tab = buffer.readInt();
                SpawnNPCData sd = job.get(slot, isDead);
                if (sd == null) {
                    sd = new SpawnNPCData();
                    slot = job.size(isDead);
                }
                sd.compound = ServerCloneController.Instance.getCloneData((ICommandSender)player, name, tab);
                if (sd.compound == null) {
                    sd.compound = new NBTTagCompound();
                }
                assert (name != null);
                sd.compound.func_74778_a("ClonedName", name);
                sd.compound.func_74768_a("ClonedTab", tab);
                sd.typeClones = 2;
                job.readJobCompound(slot, isDead, sd.writeToNBT());
            } else {
                SpawnNPCData sd = job.readJobCompound(slot, isDead, Server.readNBT(buffer));
                int tab = sd.compound.func_74762_e("ClonedTab");
                sd.typeClones = tab > 0 && tab < 10 ? 0 : 1;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.advanced.jobInterface.save(compound);
            job.cleanCompound(compound);
            compound.func_74768_a("SetPos", slot);
            compound.func_74757_a("SetDead", isDead);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.RoleCompanionUpdate) {
            if (!(npc.advanced.roleInterface instanceof RoleCompanion)) {
                return;
            }
            ((RoleCompanion)npc.advanced.roleInterface).matureTo(EnumCompanionStage.values()[buffer.readInt()]);
            npc.updateClient = true;
        } else if (type == EnumPacketServer.JobSpawnerRemove) {
            if (!(npc.advanced.jobInterface instanceof JobSpawner)) {
                return;
            }
            JobSpawner job = (JobSpawner)npc.advanced.jobInterface;
            int slot = buffer.readInt();
            boolean isDead = buffer.readBoolean();
            job.removeSpawned(slot, isDead);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.advanced.jobInterface.save(compound);
            job.cleanCompound(compound);
            compound.func_74768_a("SetPos", -1);
            compound.func_74757_a("SetDie", isDead);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.RoleSave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            if (compound.func_150297_b("Type", 3)) {
                npc.advanced.roleInterface.load(compound);
                npc.updateClient = true;
            }
        } else if (type == EnumPacketServer.RoleGet) {
            if (npc.advanced.roleInterface == null) {
                return;
            }
            NBTTagCompound compound = npc.advanced.roleInterface.save(new NBTTagCompound());
            compound.func_74757_a("RoleData", true);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.MerchantUpdate) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (!(entity instanceof EntityVillager)) {
                return;
            }
            MerchantRecipeList list = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ((EntityVillager)entity).func_70930_a(list);
        } else if (type == EnumPacketServer.ModelDataSave) {
            if (npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)npc).modelData.load(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketServer.MailOpenSetup) {
            PlayerMail mail = new PlayerMail();
            mail.readNBT(Server.readNBT(buffer));
            ContainerMail.staticmail = mail;
            player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailOpen.ordinal(), player.field_70170_p, 1, 0, 0);
        } else if (type == EnumPacketServer.TransformSave) {
            boolean isValid = npc.transform.isValid();
            npc.transform.readOptions(Server.readNBT(buffer));
            if (isValid != npc.transform.isValid()) {
                npc.updateAI = true;
            }
        } else if (type == EnumPacketServer.TransformGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.transform.writeOptions(new NBTTagCompound()));
        } else if (type == EnumPacketServer.TransformLoad) {
            if (npc.transform.isValid()) {
                npc.transform.transform(buffer.readBoolean());
            }
        } else if (type == EnumPacketServer.MovingPathGet) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("MovingPathNew", (NBTBase)NBTTags.nbtIntegerArraySet(npc.ais.getMovingPath()));
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.MovingPathSave) {
            npc.ais.setMovingPath(NBTTags.getIntegerArraySet(Server.readNBT(buffer).func_150295_c("MovingPathNew", 10)));
        } else if (type == EnumPacketServer.SpawnRider) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)Server.readNBT(buffer), (World)player.field_70170_p);
            assert (entity != null);
            player.field_70170_p.func_72838_d(entity);
            entity.func_184205_a(ServerEventsHandler.mounted, true);
        } else if (type == EnumPacketServer.PlayerRider) {
            player.func_184205_a(ServerEventsHandler.mounted, true);
        } else if (type == EnumPacketServer.SpawnMob) {
            NBTTagCompound compound;
            boolean server = buffer.readBoolean();
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            NBTTagCompound nbtData = new NBTTagCompound();
            if (server) {
                String name = Server.readString(buffer);
                int tab = buffer.readInt();
                assert (name != null);
                nbtData.func_74778_a("Name", name);
                nbtData.func_74768_a("Tab", tab);
                nbtData.func_74757_a("isServerClone", true);
                compound = ServerCloneController.Instance.getCloneData((ICommandSender)player, name, tab);
            } else {
                compound = Server.readNBT(buffer);
                nbtData.func_74778_a("Name", compound.func_74779_i("Name"));
                nbtData.func_74757_a("isServerClone", false);
            }
            if (compound == null) {
                return;
            }
            if (!server) {
                nbtData.func_74782_a("EntityNBT", (NBTBase)compound);
            }
            Entity entity = NoppesUtilServer.spawnClone(compound, (double)x + 0.5, y + 1, (double)z + 0.5, player.field_70170_p);
            ItemStack stack = player.func_184614_ca();
            NBTTagCompound nbt = null;
            if (stack.func_77973_b() == CustomRegisters.cloner && (nbt = stack.func_77978_p()) == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            if (entity == null) {
                if (nbt != null && nbt.func_74764_b("Settings")) {
                    nbt.func_82580_o("Settings");
                    player.field_71070_bA.func_75142_b();
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Failed to create an entity out of your clone. Entity not registered."));
                if (CustomNpcs.VerboseDebug && player.field_71075_bZ.field_75098_d) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Entity ID: \"" + compound.func_74779_i("id") + "\""));
                    ResourceLocation locN = new ResourceLocation("customnpcs", "CustomNpc");
                    ResourceLocation locS = new ResourceLocation("customnpcs", "customnpc");
                    player.func_145747_a((ITextComponent)new TextComponentString("NPC is registered: (normal) " + (EntityList.getClass((ResourceLocation)locN) != null) + "; (simple) " + (EntityList.getClass((ResourceLocation)locS) != null)));
                }
            } else if (nbt != null) {
                if (!nbtData.func_150297_b("Name", 8) || nbtData.func_74779_i("Name").isEmpty()) {
                    nbtData.func_74778_a("Name", entity.func_70005_c_());
                }
                nbt.func_74782_a("Settings", (NBTBase)nbtData);
                player.field_71070_bA.func_75142_b();
            }
        } else if (type == EnumPacketServer.MobSpawner) {
            boolean server = buffer.readBoolean();
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            NBTTagCompound compound = server ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound != null) {
                NoppesUtilServer.createMobSpawner(pos, compound, (EntityPlayer)player);
            }
        } else if (type == EnumPacketServer.ClonePreSave) {
            boolean bo = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt()) != null;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("NameExists", bo);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneSave) {
            PlayerData data = PlayerData.get((EntityPlayer)player);
            if (data.cloned == null) {
                LogWriter.error("Error save entity: NBT is Empty!");
                return;
            }
            ServerCloneController.Instance.addClone(data.cloned, Server.readString(buffer), buffer.readInt());
            data.cloned = null;
        } else if (type == EnumPacketServer.CloneRemove) {
            int tab = buffer.readInt();
            ServerCloneController.Instance.removeClone(Server.readString(buffer), tab);
            NBTTagList list = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClones(tab)) {
                list.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("List", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneSet) {
            PlayerData.get((EntityPlayer)player).cloned = Server.readNBT(buffer);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClones(buffer.readInt())) {
                list.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("List", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptDataSave) {
            npc.script.readFromNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.script.lastInited = -1L;
        } else if (type == EnumPacketServer.ScriptDataGet) {
            NoppesUtilServer.sendScriptData(player, npc.script.writeToNBT(new NBTTagCompound()), npc.script.getScripts());
        } else if (type == EnumPacketServer.DimensionSettings) {
            int id = buffer.readInt();
            CustomWorldInfo wi = Server.readWorldInfo(buffer);
            if (id == 0) {
                DimensionHandler.getInstance().createDimension(player, wi);
            } else {
                CustomWorldInfo cwi = (CustomWorldInfo)DimensionHandler.getInstance().getMCWorldInfo(id);
                if (cwi != null) {
                    cwi.load(wi.read());
                }
            }
        } else if (type == EnumPacketServer.DimensionDelete) {
            int delID = buffer.readInt();
            DimensionHandler.getInstance().deleteDimension((ICommandSender)player, delID);
            NoppesUtilServer.sendScrollData(player, DimensionHandler.getInstance().getMapDimensionsIDs());
        } else if (type == EnumPacketServer.DimensionsGet) {
            NoppesUtilServer.sendScrollData(player, DimensionHandler.getInstance().getMapDimensionsIDs());
        } else if (type == EnumPacketServer.DimensionTeleport) {
            int dimension = buffer.readInt();
            WorldServer world = Objects.requireNonNull(player.func_184102_h()).func_71218_a(dimension);
            BlockPos coords = world.func_180504_m();
            if (coords == null) {
                coords = world.func_175694_M();
                if (!world.func_175623_d(coords)) {
                    coords = world.func_175672_r(coords);
                } else {
                    while (world.func_175623_d(coords) && coords.func_177956_o() > 0) {
                        coords = coords.func_177977_b();
                    }
                    if (coords.func_177956_o() == 0) {
                        coords = world.func_175672_r(coords);
                    }
                }
            }
            NoppesUtilPlayer.teleportPlayer(player, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), dimension, player.field_70177_z, player.field_70125_A);
        } else if (type == EnumPacketServer.ScriptBlockDataGet) {
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()));
            if (!(tile instanceof TileScripted)) {
                return;
            }
            NoppesUtilServer.sendScriptData(player, ((TileScripted)tile).getNBT(new NBTTagCompound()), ((TileScripted)tile).getScripts());
        } else if (type == EnumPacketServer.ScriptItemDataGet) {
            ItemScriptedWrapper iw = (ItemScriptedWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(player.func_184614_ca());
            NoppesUtilServer.sendScriptData(player, iw.getMCNbt(), iw.getScripts());
        } else if (type == EnumPacketServer.ScriptItemDataSave) {
            if (!player.func_184812_l_()) {
                return;
            }
            NBTTagCompound compound = Server.readNBT(buffer);
            ItemScriptedWrapper wrapper = (ItemScriptedWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(player.func_184614_ca());
            wrapper.setMCNbt(compound);
            wrapper.lastInited = -1L;
            wrapper.saveScriptData();
            wrapper.updateClient = true;
            player.func_71120_a(player.field_71069_bz);
        } else if (type == EnumPacketServer.ScriptForgeGet) {
            ForgeScriptData data = ScriptController.Instance.forgeScripts;
            NoppesUtilServer.sendScriptData(player, data.writeToNBT(new NBTTagCompound()), data.getScripts());
        } else if (type == EnumPacketServer.ScriptNpcsGet) {
            NpcScriptData data = ScriptController.Instance.npcsScripts;
            NoppesUtilServer.sendScriptData(player, data.writeToNBT(new NBTTagCompound()), data.getScripts());
        } else if (type == EnumPacketServer.ScriptForgeSave) {
            ScriptController.Instance.setForgeScripts(Server.readNBT(buffer));
        } else if (type == EnumPacketServer.ScriptNpcsSave) {
            ScriptController.Instance.setNPCsScripts(Server.readNBT(buffer));
        } else if (type == EnumPacketServer.ScriptClientGet) {
            ClientScriptData data = ScriptController.Instance.clientScripts;
            NoppesUtilServer.sendScriptData(player, data.writeToNBT(new NBTTagCompound()), data.getScripts());
        } else if (type == EnumPacketServer.ScriptClientSave) {
            ScriptController.Instance.setClientScripts(Server.readNBT(buffer));
            for (EntityPlayerMP pl : player.field_71133_b.func_184103_al().func_181057_v()) {
                ScriptController.Instance.sendClientTo(pl);
            }
        } else if (type == EnumPacketServer.ScriptPlayerGet) {
            NoppesUtilServer.sendScriptData(player, ScriptController.Instance.playerScripts.writeToNBT(new NBTTagCompound()), ScriptController.Instance.playerScripts.getScripts());
        } else if (type == EnumPacketServer.ScriptPlayerSave) {
            ScriptController.Instance.setPlayerScripts(Server.readNBT(buffer));
        } else if (type == EnumPacketServer.FactionsGet) {
            NoppesUtilServer.sendFactionDataAll(player);
        } else if (type == EnumPacketServer.FactionGet) {
            NBTTagCompound compound = new NBTTagCompound();
            Faction faction = FactionController.instance.getFaction(buffer.readInt());
            faction.save(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.SaveTileEntity) {
            NoppesUtilServer.saveTileEntity(player, Server.readNBT(buffer));
        } else if (type == EnumPacketServer.GetTileEntity) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile != null) {
                NBTTagCompound compound = new NBTTagCompound();
                tile.func_189515_b(compound);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.ScriptBlockDataSave) {
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()));
            if (!(tile instanceof TileScripted)) {
                return;
            }
            TileScripted script = (TileScripted)tile;
            script.setNBT(Server.readNBT(buffer));
            script.lastInited = -1L;
        } else if (type == EnumPacketServer.ScriptDoorDataSave) {
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()));
            if (!(tile instanceof TileScriptedDoor)) {
                return;
            }
            TileScriptedDoor script = (TileScriptedDoor)tile;
            script.setNBT(Server.readNBT(buffer));
            script.lastInited = -1L;
        } else if (type == EnumPacketServer.ScriptDoorDataGet) {
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()));
            if (!(tile instanceof TileScriptedDoor)) {
                return;
            }
            NoppesUtilServer.sendScriptData(player, ((TileScriptedDoor)tile).getNBT(new NBTTagCompound()), ((TileScriptedDoor)tile).getScripts());
        } else if (type == EnumPacketServer.SchematicsTile) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileBuilder tile = (TileBuilder)player.field_70170_p.func_175625_s(pos);
            if (tile == null) {
                return;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, tile.writePartNBT(new NBTTagCompound()));
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, SchematicController.Instance.list());
            if (tile.hasSchematic()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, tile.getSchematic().getNBTSmall());
            }
        } else if (type == EnumPacketServer.SchematicsSet) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileBuilder tile = (TileBuilder)player.field_70170_p.func_175625_s(pos);
            if (tile == null) {
                return;
            }
            String name = Server.readString(buffer);
            tile.setSchematic(SchematicController.Instance.load(name));
            if (tile.hasSchematic()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, tile.getSchematic().getNBTSmall());
            }
        } else if (type == EnumPacketServer.SchematicsBuild) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity t = player.field_70170_p.func_175625_s(pos);
            if (t instanceof TileBuilder) {
                TileBuilder tile = (TileBuilder)t;
                SchematicWrapper schem = tile.getSchematic();
                schem.init(pos.func_177982_a(1, tile.yOffset, 1), player.field_70170_p, tile.rotation * 90);
                SchematicController.Instance.build(tile.getSchematic(), (ICommandSender)player);
                player.field_70170_p.func_175698_g(pos);
            } else {
                int rotation = buffer.readInt();
                NBTTagCompound compound = Server.readNBT(buffer);
                Schematic schema = new Schematic("");
                schema.load(compound);
                SchematicController.buildBlocks(player, pos, rotation, schema);
            }
        } else if (type == EnumPacketServer.SchematicsTileSave) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile instanceof TileBuilder) {
                ((TileBuilder)tile).readPartNBT(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketServer.SchematicStore) {
            String name = Server.readString(buffer);
            int t = buffer.readInt();
            TileCopy tile = (TileCopy)NoppesUtilServer.saveTileEntity(player, Server.readNBT(buffer));
            if (tile == null || Objects.requireNonNull(name).isEmpty()) {
                return;
            }
            SchematicController.Instance.save((ICommandSender)player, name, t, tile.func_174877_v(), tile.height, tile.width, tile.length);
        } else if (type == EnumPacketServer.NbtBookSaveBlock) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            NBTTagCompound compound = Server.readNBT(buffer);
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile != null) {
                tile.func_145839_a(compound);
                tile.func_70296_d();
                CustomNpcs.proxy.fixTileEntityData(tile);
            }
        } else if (type == EnumPacketServer.NbtBookSaveEntity) {
            int entityId = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = player.field_70170_p.func_73045_a(entityId);
            if (entity != null) {
                entity.func_70020_e(compound);
            }
        } else if (type == EnumPacketServer.NbtBookSaveItem) {
            NBTTagCompound stackNBT = Server.readNBT(buffer);
            ItemStack stack = new ItemStack(stackNBT);
            if (stack.func_190926_b()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("nbt.book.not.correct.nbt", new Object[0]));
                return;
            }
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
            player.field_71070_bA.func_75142_b();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("Item", true);
            compound.func_74782_a("Data", (NBTBase)stackNBT);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.NbtBookCopyStack) {
            EntityItem entity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Server.readNBT(buffer)));
            entity.func_174867_a(5);
            player.field_70170_p.func_72838_d((Entity)entity);
        } else if (type == EnumPacketServer.RecipesAddGroup) {
            boolean isGlobal = buffer.readBoolean();
            String group = Server.readString(buffer);
            NpcShapedRecipes recipe = new NpcShapedRecipes(group, "default", isGlobal, (NonNullList<Ingredient>)NonNullList.func_191196_a(), ItemStack.field_190927_a);
            RecipeController.getInstance().register(recipe);
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.RecipeAdd) {
            NBTTagCompound compound = Server.readNBT(buffer);
            IRecipe recipe = compound.func_74767_n("IsShaped") ? NpcShapedRecipes.read(compound) : NpcShapelessRecipes.read(compound);
            RecipeController.getInstance().register((INpcRecipe)recipe);
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.RecipesRenameGroup) {
            RecipeController.getInstance().renameGroup(buffer.readBoolean(), Server.readString(buffer), Server.readString(buffer));
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.RecipeRemoveGroup) {
            RecipeController.getInstance().deleteGroup(buffer.readBoolean(), Server.readString(buffer));
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.RecipesRename) {
            RecipeController.getInstance().renameRecipe(buffer.readBoolean(), Server.readString(buffer), Server.readString(buffer), Server.readString(buffer));
            Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
        } else if (type == EnumPacketServer.TraderMarketSave) {
            MarcetController mData = MarcetController.getInstance();
            NBTTagCompound compound = Server.readNBT(buffer);
            if (compound.func_150297_b("DealID", 3)) {
                mData.loadDeal(compound);
            } else {
                mData.loadMarcet(compound);
            }
            MarcetController.getInstance().saveMarcets();
        } else if (type == EnumPacketServer.TraderMarketGet) {
            int id = -1;
            try {
                id = buffer.readInt();
            }
            catch (Exception compound) {
                // empty catch block
            }
            MarcetController.getInstance().sendTo(player, id);
        } else if (type == EnumPacketServer.TraderMarketDel) {
            MarcetController mData = MarcetController.getInstance();
            int marketID = buffer.readInt();
            int dealID = buffer.readInt();
            if (marketID >= 0 && dealID < 0) {
                Server.sendData(player, EnumPacketClient.SYNC_REMOVE, new Object[]{EnumSync.MarcetData, marketID});
                mData.removeMarcet(marketID);
            }
            if (marketID < 0 && dealID >= 0) {
                Server.sendData(player, EnumPacketClient.SYNC_REMOVE, new Object[]{EnumSync.MarcetDeal, dealID});
                mData.removeDeal(dealID);
            }
            MarcetController.getInstance().sendTo(player, marketID);
        } else if (type == EnumPacketServer.GetClone) {
            NBTTagCompound npcNbt = null;
            if (buffer.readBoolean()) {
                SpawnNPCData sd;
                if (npc != null && npc.advanced.jobInterface instanceof JobSpawner && (sd = ((JobSpawner)npc.advanced.jobInterface).get(buffer.readInt(), buffer.readBoolean())) != null && sd.compound != null) {
                    npcNbt = sd.compound;
                    if (sd.typeClones == 2) {
                        npcNbt = ServerCloneController.Instance.getCloneData((ICommandSender)player, sd.compound.func_74779_i("ClonedName"), sd.compound.func_74762_e("ClonedTab"));
                    }
                }
            } else {
                npcNbt = ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt());
            }
            if (npcNbt != null) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("NPCData", (NBTBase)npcNbt);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.ScriptPotionGet) {
            PotionScriptData data = ScriptController.Instance.potionScripts;
            NoppesUtilServer.sendScriptData(player, data.writeToNBT(new NBTTagCompound()), data.getScripts());
        } else if (type == EnumPacketServer.ScriptPotionSave) {
            ScriptController.Instance.setPotionScripts(Server.readNBT(buffer));
        } else if (type == EnumPacketServer.TeleportTo) {
            int dimensionId = buffer.readInt();
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            if (player.field_70170_p.field_73011_w.getDimension() == dimensionId) {
                player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                return;
            }
            try {
                Util.instance.teleportEntity(CustomNpcs.Server, (Entity)player, dimensionId, pos);
            }
            catch (Exception e) {
                LogWriter.error("Error teleport entity:", e);
            }
        } else if (type == EnumPacketServer.RegionData) {
            Zone3D reg;
            int regId;
            int t = buffer.readInt();
            BorderController bData = BorderController.getInstance();
            if (t == 0) {
                regId = buffer.readInt();
                if (!bData.regions.containsKey(regId)) {
                    bData.sendTo(player);
                    return;
                }
                if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemBoundary) {
                    NBTTagCompound compound = player.func_184614_ca().func_77978_p();
                    if (compound == null) {
                        compound = new NBTTagCompound();
                        player.func_184614_ca().func_77982_d(compound);
                    }
                    compound.func_74768_a("RegionID", regId);
                }
            } else if (t == 1) {
                regId = buffer.readInt();
                if (!bData.regions.containsKey(regId)) {
                    bData.sendTo(player);
                    return;
                }
                if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemBoundary) {
                    Object compound = player.func_184614_ca().func_77978_p();
                    if (compound == null) {
                        compound = new NBTTagCompound();
                        player.func_184614_ca().func_77982_d((NBTTagCompound)compound);
                    }
                    compound.func_82580_o("RegionID");
                }
                if (bData.removeRegion(regId)) {
                    for (EntityPlayerMP p : CustomNpcs.Server.func_184103_al().func_181057_v()) {
                        bData.sendTo(p);
                    }
                }
            }
            if (t == 2 && (reg = bData.loadRegion(Server.readNBT(buffer))) != null) {
                bData.save();
                bData.update(reg.getId());
            }
        } else if (type == EnumPacketServer.BuilderSetting) {
            NBTTagCompound compound;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ISpecBuilder && (compound = Server.readNBT(buffer)).func_150297_b("ID", 3) && compound.func_150297_b("BuilderType", 3)) {
                int id = compound.func_74762_e("ID");
                BuilderData bd = SyncController.dataBuilder.get(id);
                if (id < 0 || bd == null) {
                    if (id < 0 && bd != null) {
                        SyncController.dataBuilder.remove(id);
                    }
                    id = 0;
                    while (SyncController.dataBuilder.containsKey(id)) {
                        ++id;
                    }
                    bd = new BuilderData(id, compound.func_74762_e("BuilderType"));
                    compound.func_74768_a("ID", id);
                }
                bd.read(compound);
                SyncController.dataBuilder.put(id, bd);
                NBTTagCompound nbtStack = bd.getNbt();
                if (compound.func_74762_e("BuilderType") != ((ISpecBuilder)stack.func_77973_b()).getType()) {
                    switch (compound.func_74762_e("BuilderType")) {
                        case 1: {
                            stack = new ItemStack(CustomRegisters.npcbuilder);
                            break;
                        }
                        case 2: {
                            stack = new ItemStack(CustomRegisters.npcreplacer);
                            break;
                        }
                        case 3: {
                            stack = new ItemStack(CustomRegisters.npcplacer);
                            break;
                        }
                        case 4: {
                            stack = new ItemStack(CustomRegisters.npcsaver);
                            break;
                        }
                        default: {
                            stack = new ItemStack(CustomRegisters.npcremover);
                            break;
                        }
                    }
                } else {
                    stack = stack.func_77946_l();
                }
                stack.func_77982_d(nbtStack);
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
                player.field_71070_bA.func_75142_b();
                Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.BuilderData, nbtStack});
            }
        } else if (type == EnumPacketServer.DialogCategoryGet) {
            for (DialogCategory category : DialogController.instance.categories.values()) {
                Server.sendData(player, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.DialogCategoriesData, category.save(new NBTTagCompound())});
            }
            Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.DialogCategoriesData, new NBTTagCompound()});
        } else if (type == EnumPacketServer.QuestCategoryGet) {
            for (QuestCategory category : QuestController.instance.categories.values()) {
                Server.sendData(player, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.QuestCategoriesData, category.save(new NBTTagCompound())});
            }
            Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.QuestCategoriesData, new NBTTagCompound()});
        } else if (type == EnumPacketServer.AnimationGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.animation.save(new NBTTagCompound()));
            AnimationController.getInstance().sendTo(player);
        } else if (type == EnumPacketServer.EmotionChange) {
            NBTTagCompound compound = Server.readNBT(buffer);
            if (compound.func_150296_c().isEmpty()) {
                AnimationController.getInstance().emotions.clear();
            } else if (compound.func_150297_b("delete", 1) && compound.func_74767_n("delete")) {
                AnimationController.getInstance().removeEmotion(compound.func_74762_e("ID"));
            } else if (compound.func_150297_b("save", 1) && compound.func_74767_n("save")) {
                AnimationController.getInstance().save();
            } else {
                AnimationController.getInstance().loadEmotion(compound);
            }
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.AnimationData, compound});
        } else if (type == EnumPacketServer.AnimationChange) {
            NBTTagCompound compound = Server.readNBT(buffer);
            if (compound.func_150296_c().isEmpty()) {
                AnimationController.getInstance().animations.clear();
            } else if (compound.func_150297_b("delete", 1) && compound.func_74767_n("delete")) {
                AnimationController.getInstance().removeAnimation(compound.func_74762_e("ID"));
            } else if (compound.func_150297_b("save", 1) && compound.func_74767_n("save")) {
                AnimationController.getInstance().save();
            } else {
                AnimationController.getInstance().loadAnimation(compound);
            }
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.AnimationData, compound});
        } else if (type == EnumPacketServer.AnimationSave) {
            npc.animation.load(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.AnimationGlobalSave) {
            AnimationController aData = AnimationController.getInstance();
            NBTTagCompound compound = Server.readNBT(buffer);
            AnimationConfig ac = (AnimationConfig)aData.createNewAnim();
            int id = ac.id;
            ac.load(compound);
            ac.id = id;
            aData.save();
            player.func_145747_a((ITextComponent)new TextComponentTranslation("animation.message.save", new Object[]{ac.name}));
            aData.sendTo(player);
        } else if (type == EnumPacketServer.PlayerDataSet) {
            EnumPlayerData datatype = EnumPlayerData.values()[buffer.readInt()];
            String playerName = Server.readString(buffer);
            assert (playerName != null);
            EntityPlayerMP pl = Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_152612_a(playerName);
            PlayerData playerdata = pl == null ? PlayerDataController.instance.getDataFromUsername(player.func_184102_h(), playerName) : PlayerData.get((EntityPlayer)pl);
            if (playerdata == null) {
                return;
            }
            boolean isChange = false;
            int t = buffer.readInt();
            switch (datatype) {
                case Quest: {
                    int questId = buffer.readInt();
                    Quest q = QuestController.instance.quests.get(questId);
                    if (t == 0 && q != null && !playerdata.questData.finishedQuests.containsKey(questId)) {
                        playerdata.questData.activeQuests.remove(questId);
                        if (q.repeat == EnumQuestRepeat.RLDAILY || q.repeat == EnumQuestRepeat.RLWEEKLY) {
                            playerdata.questData.finishedQuests.put(questId, System.currentTimeMillis());
                        } else {
                            playerdata.questData.finishedQuests.put(questId, player.field_70170_p.func_82737_E());
                        }
                        isChange = true;
                        break;
                    }
                    if (t == 1 && (playerdata.questData.finishedQuests.containsKey(questId) || playerdata.questData.activeQuests.containsKey(questId))) {
                        playerdata.questData.finishedQuests.remove(questId);
                        playerdata.questData.activeQuests.remove(questId);
                        isChange = true;
                        break;
                    }
                    if (t != 3) break;
                    playerdata.questData.finishedQuests.clear();
                    playerdata.questData.activeQuests.clear();
                    isChange = true;
                    break;
                }
                case Dialog: {
                    int dialogId = buffer.readInt();
                    Dialog d = DialogController.instance.dialogs.get(dialogId);
                    if (t == 0 && d != null && !playerdata.dialogData.has(dialogId)) {
                        playerdata.dialogData.read(dialogId);
                        isChange = true;
                        break;
                    }
                    if (t == 1 && playerdata.dialogData.has(dialogId)) {
                        playerdata.dialogData.dialogsRead.remove(dialogId);
                        isChange = true;
                        break;
                    }
                    if (t != 3) break;
                    playerdata.dialogData.dialogsRead.clear();
                    isChange = true;
                    break;
                }
                case Transport: {
                    int locationId = buffer.readInt();
                    TransportLocation l = TransportController.getInstance().getTransport(locationId);
                    if (t == 0 && l != null && !playerdata.transportData.transports.contains(locationId)) {
                        playerdata.transportData.transports.add(locationId);
                        isChange = true;
                        break;
                    }
                    if (t == 1 && playerdata.transportData.transports.contains(locationId)) {
                        playerdata.transportData.transports.remove(locationId);
                        isChange = true;
                        break;
                    }
                    if (t != 3) break;
                    playerdata.transportData.transports.clear();
                    isChange = true;
                    break;
                }
                case Bank: {
                    int bankId = buffer.readInt();
                    BankData bd = playerdata.bankData.get(bankId);
                    if (t == 0 && bd != null && bd.bank != null) {
                        bd.save();
                        isChange = true;
                        break;
                    }
                    if (t == 1) {
                        playerdata.bankData.remove(bankId);
                        isChange = true;
                        break;
                    }
                    if (t != 3) break;
                    bd.clear();
                    bd.save();
                    isChange = true;
                    break;
                }
                case Factions: {
                    int factionId = buffer.readInt();
                    Faction f = FactionController.instance.factions.get(factionId);
                    if (t == 0 && f != null && !playerdata.factionData.factionData.containsKey(factionId)) {
                        playerdata.factionData.factionData.put(factionId, f.defaultPoints);
                        isChange = true;
                        break;
                    }
                    if (t == 1 && playerdata.factionData.factionData.containsKey(factionId)) {
                        playerdata.factionData.factionData.remove(factionId);
                        isChange = true;
                        break;
                    }
                    if (t == 2 && playerdata.factionData.factionData.containsKey(factionId)) {
                        playerdata.factionData.factionData.put(factionId, buffer.readInt());
                        isChange = true;
                        break;
                    }
                    if (t != 3) break;
                    playerdata.factionData.factionData.clear();
                    isChange = true;
                    break;
                }
                case Game: {
                    if (t == 3) {
                        playerdata.game.setMoney(0L);
                        playerdata.game.marketData.clear();
                    } else {
                        NBTTagCompound compound = Server.readNBT(buffer);
                        playerdata.game.readFromNBT(compound);
                    }
                    isChange = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (isChange) {
                playerdata.save(true);
                if (pl != null) {
                    pl.func_145747_a((ITextComponent)new TextComponentTranslation("message.change.mod.data", new Object[0]));
                }
                NoppesUtilServer.sendPlayerData(datatype, player, playerName);
            }
        } else if (type == EnumPacketServer.PlayerDataCleaning) {
            long time = buffer.readLong();
            File dirGame = CustomNpcs.getWorldSaveDirectory().getParentFile();
            File dirMod = CustomNpcs.getWorldSaveDirectory("playerdata");
            int i = 0;
            int s = Objects.requireNonNull(Objects.requireNonNull(dirMod).listFiles()).length;
            List<String> opn = Arrays.asList(Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_72369_d());
            for (File dir : Objects.requireNonNull(dirMod.listFiles())) {
                if (!dir.isDirectory()) {
                    if (!dir.getName().endsWith(".json")) continue;
                    Util.instance.removeFile(dir);
                    continue;
                }
                String uuid = dir.getName();
                boolean needDelete = false;
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    if (!file.getName().endsWith(".json") || file.lastModified() >= time) continue;
                    String name = file.getName().substring(0, file.getName().length() - 5);
                    needDelete = !opn.contains(name);
                    break;
                }
                if (!needDelete || !PacketHandlerServer.isDelete(dir, dirGame, uuid)) continue;
                ++i;
            }
            if (i > 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.data.cleaning.true", new Object[]{"" + i, "" + s}));
                NoppesUtilServer.sendPlayerData(EnumPlayerData.Players, player, null);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.data.cleaning.false", new Object[]{"" + s}));
            }
        } else if (type == EnumPacketServer.PlayerMailsGet) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("LettersBeDeleted", CustomNpcs.MailTimeWhenLettersWillBeDeleted);
            compound.func_74783_a("LettersBeReceived", CustomNpcs.MailTimeWhenLettersWillBeReceived);
            compound.func_74783_a("CostSendingLetter", CustomNpcs.MailCostSendingLetter);
            compound.func_74757_a("SendToYourself", CustomNpcs.MailSendToYourself);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.PlayerMailsSave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            CustomNpcs.MailTimeWhenLettersWillBeDeleted = compound.func_74762_e("LettersBeDeleted");
            int[] vs = compound.func_74759_k("LettersBeReceived");
            System.arraycopy(vs, 0, CustomNpcs.MailTimeWhenLettersWillBeReceived, 0, vs.length);
            vs = compound.func_74759_k("CostSendingLetter");
            System.arraycopy(vs, 0, CustomNpcs.MailCostSendingLetter, 0, vs.length);
            CustomNpcs.MailSendToYourself = compound.func_74767_n("SendToYourself");
            compound = new NBTTagCompound();
            compound.func_74768_a("LettersBeDeleted", CustomNpcs.MailTimeWhenLettersWillBeDeleted);
            compound.func_74783_a("LettersBeReceived", CustomNpcs.MailTimeWhenLettersWillBeReceived);
            compound.func_74783_a("CostSendingLetter", CustomNpcs.MailCostSendingLetter);
            compound.func_74757_a("SendToYourself", CustomNpcs.MailSendToYourself);
            if (Objects.requireNonNull(player.field_70170_p.func_73046_m()).func_184103_al().func_181057_v().size() > 1) {
                for (EntityPlayerMP pl : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
                    Server.sendData(pl, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.MailData, compound});
                }
            }
        } else if (type == EnumPacketServer.GetResistances) {
            TreeMap<String, Integer> map = new TreeMap<String, Integer>();
            for (String name : Resistances.allDamageNames) {
                map.put(name, 0);
            }
            NoppesUtilServer.sendScrollData(player, map);
        } else if (type == EnumPacketServer.DropTemplateSave) {
            DropController dData = DropController.getInstance();
            int t = buffer.readInt();
            if (t == 0) {
                dData.templates.clear();
            } else if (t == 1) {
                NBTTagCompound nbtTemplate = Server.readNBT(buffer);
                if (!nbtTemplate.func_150297_b("Name", 8) || !nbtTemplate.func_150297_b("Groups", 10)) {
                    return;
                }
                dData.templates.put(nbtTemplate.func_74779_i("Name"), new DropsTemplate(nbtTemplate.func_74775_l("Groups")));
            } else if (t == 2) {
                String name = Server.readString(buffer);
                assert (name != null);
                if (name.isEmpty() || !dData.templates.containsKey(name)) {
                    return;
                }
                dData.templates.remove(name);
            }
            dData.save();
        } else if (type == EnumPacketServer.SetItem) {
            ItemStack stack = new ItemStack(Server.readNBT(buffer));
            player.field_71071_by.func_70437_b(stack);
            player.field_71070_bA.func_75142_b();
        } else if (type == EnumPacketServer.RemoveNpcEdit) {
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, null);
        } else if (type == EnumPacketServer.AvailabilityStacks) {
            Availability availability = new Availability();
            availability.load(Server.readNBT(buffer));
            CommonProxy.availabilityStacks.put((EntityPlayer)player, availability);
        } else if (type == EnumPacketServer.AvailabilitySlot) {
            if (player.field_71070_bA instanceof ContainerAvailabilityInv) {
                ((ContainerAvailabilityInv)player.field_71070_bA).slot.setSlotIndex(buffer.readInt(), true);
            }
        } else if (type == EnumPacketServer.ChangeItemInSlot && player.field_71070_bA.getClass().getSimpleName().equals(Server.readString(buffer))) {
            player.field_71070_bA.func_75141_a(buffer.readInt(), new ItemStack(Server.readNBT(buffer)));
            player.field_71070_bA.func_75142_b();
        }
    }

    private static boolean isDelete(File dir, File dirGame, String uuid) {
        File playerdata;
        File stats;
        boolean bo = dir.delete();
        File advancements = new File(dirGame, "advancements/" + uuid);
        if (advancements.exists()) {
            bo = advancements.delete();
        }
        if ((stats = new File(dirGame, "stats/" + uuid)).exists()) {
            bo = stats.delete();
        }
        if ((playerdata = new File(dirGame, "playerdata/" + uuid + ".dat")).exists()) {
            bo = playerdata.delete();
        }
        return bo;
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        ByteBuf buffer = event.getPacket().payload();
        Objects.requireNonNull(player.func_184102_h()).func_152344_a(() -> {
            EnumPacketServer type = null;
            try {
                type = EnumPacketServer.values()[buffer.readInt()];
                CustomNpcs.debugData.start(null, type.toString());
                if (CustomNpcs.OpsOnly && !NoppesUtilServer.isOp((EntityPlayer)player)) {
                    this.warn((EntityPlayer)player, "tried to use custom npcs without being an op TypePacket: " + (Object)((Object)type));
                    CustomNpcs.debugData.end(null, type.toString());
                    return;
                }
                if (!list.contains((Object)type)) {
                    LogWriter.debug("Received: " + (Object)((Object)type));
                }
                ItemStack item = player.field_71071_by.func_70448_g();
                EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                if (!type.needsNpc || npc != null) {
                    if (!type.hasPermission() || CustomNpcsPermissions.hasPermission((EntityPlayer)player, type.permission)) {
                        if (!(list.contains((Object)type) || type.isExempt() || this.allowItem(item, type))) {
                            this.warn((EntityPlayer)player, "tried to use custom npcs without a tool in hand, possibly a hacker");
                        } else {
                            this.handlePacket(type, buffer, player, npc);
                        }
                    }
                } else {
                    LogWriter.error("Error with EnumPacketServer." + (Object)((Object)type) + ". Not found Editing Npc");
                }
                CustomNpcs.debugData.end(null, type.toString());
            }
            catch (Exception e) {
                LogWriter.error("Error with EnumPacketServer." + (Object)((Object)type), e);
            }
            finally {
                buffer.release();
            }
        });
    }

    private void warn(EntityPlayer player, String warning) {
        Objects.requireNonNull(player.func_184102_h()).func_71236_h(player.func_70005_c_() + ": " + warning);
    }

    static {
        list.add(EnumPacketServer.RemoteReset);
        list.add(EnumPacketServer.AvailabilitySlot);
        list.add(EnumPacketServer.ChangeItemInSlot);
    }
}

